package gov.va.med.mhv.admin.repository;

import gov.va.med.mhv.admin.model.Org;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface OrganizationRepository extends JpaRepository<Org, Long> {

	@Query("select org from Org org where org.typeOfOrganization=:orgType")
	List<Org> getOrganizationsOfType(@Param("orgType") String orgType);

	@Query("select distinct o from Org o  where o.id = :orgId")
	Org getOrganization(@Param("orgId") long orgId);

	@Query("select distinct org from Org org, EmployeeOrgRole as empOrgRole"
			+ " where empOrgRole.employee.id=:employeeId" + " and empOrgRole.role.securityAdmin=1"
			+ " and empOrgRole.active=1"
			+ " and (org.id=empOrgRole.organization.id or org.parentOrganization=empOrgRole.organization.id)")
	List<Org> getOrganizationsEmployeeCanManage(@Param("employeeId") Long employeeId);

	@Query("select distinct organization from Org organization, EmployeeOrgRole as empOrgRole"
			+ " where organization.typeOfOrganization=:orgType" + " and empOrgRole.role.name=:roleName"
			+ " and empOrgRole.employee.id=:employeeId" + " and empOrgRole.active=1"
			+ " and organization.id=empOrgRole.organization.id")
	List<Org> getOrganizationsOfTypeWhereEmployeeHasRole(@Param("employeeId") Long employeeId,
			@Param("orgType") String orgType, @Param("roleName") String roleName);

}
